#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) 2012 GSyC/LibreSoft, Universidad Rey Juan Carlos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Authors: Luis Cañas Díaz <lcanas@libresoft.es>

import sys

if not ".." in sys.path:
    sys.path.insert(0, '..')

from tests import get_test

_backends = ['launchpad']


#
# we'll need a database, user and password
#

if __name__ == '__main__':
    if len(sys.argv) > 1:
        _backends = sys.argv[1:]
        for backend in _backends:
            func = get_test(backend)
            if func is not None:
                t = func()
                print "Testing %s" % (backend)
                t.run()
                print
